<?xml version="1.0"?>
<queryset>

    <fullquery name="attribute_new">
	<querytext>

	    select ca_attributes__create_attribute ( 
	    	:content_type::varchar, 
		:attribute_name::varchar, 
		:datatype::varchar, 
		:pretty_name::varchar, 
		:pretty_plural::varchar, 
		:sort_order::int4, 
		:default_value::varchar, 
		'type_specific'::varchar, 
		'cr_ca_ads'::varchar, 
		:column_spec::varchar, 
		:keyword_id::int4
	    ) as attribute_id

	</querytext>
    </fullquery>

    <fullquery name="widget_new">
	<querytext>

	    select ca_attributes__register_widget (
	    	:attribute_id, 
		:widget, 
		:label, 
		:html_options, 
		:extra_options,
		:select_options, 
		:validate, 
		:optional_p,
		:enabled_p
	    )
	    
	</querytext>
    </fullquery>

    <fullquery name="get_column_spec">
	<querytext>

  SELECT pg_catalog.format_type(a.atttypid, a.atttypmod)
    FROM pg_catalog.pg_attribute a,
         (
		  SELECT c.oid
  		    FROM pg_catalog.pg_class c
         		 LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
	 	   WHERE pg_catalog.pg_table_is_visible(c.oid)
	       	     AND c.relname ~ '^cr_ca_ads$'
	 ) b
   WHERE a.attrelid = b.oid 
     AND a.attname = :attribute_name 
     AND NOT a.attisdropped

	</querytext>
    </fullquery>

</queryset>
