ad_page_contract {
    
    Create a Classified Ads Category

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-10-08
    @cvs-id $Id: category-new.tcl,v 1.3 2003/08/21 02:02:51 rmello Exp $

} {
    parent_id:integer,notnull
    {return_url "categories"}
}

ad_form -name category -form {
	keyword_id:key
	{parent_id:integer(hidden)	{label "Parent ID"}
					{value $parent_id} }
	{return_url:text(hidden)	{label "Return URL"}
					{value $return_url} }
	{heading:text(text)		{label "Category"}
					{html {size 60} {maxlength 6000}} }
	{description:text(textarea),optional	{label "Description"}
						{html {cols 60 rows 10 wrap soft}} }
} -new_data {
	if {[catch {set keyword_id \
			[classified-ads::categories::new -keyword_id $keyword_id \
							-heading $heading \
							-parent_id $parent_id \
							-description $description \
			]} errmsg]
	} {
		ad_return_error "Problems processing this page" \
				"We had problems processing this page. Administration has been notified"
		ad_script_abort
	}

	ad_returnredirect $return_url
	ad_script_abort
}

set title "Create Category"
set context [classified-ads::categories::generate_trail -keyword_id $parent_id -append_element $title]

ad_return_template
