ad_page_contract {
    
    Edit a Classified Ads Category

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-10-08
    @cvs-id $Id: category-edit.tcl,v 1.1 2003/07/16 04:52:32 rmello Exp $

} {
    keyword_id:integer,notnull
    {return_url "categories"}
}

form create category

element create category keyword_id \
    -label "Keyword ID" \
    -datatype integer \
    -widget hidden

element create category return_url \
    -label "Return URL" \
    -datatype text\
    -widget hidden

element create category heading \
    -label "Category" \
    -datatype text \
    -widget text \
    -html {size 60} {maxlength 600}

element create category description \
    -label "Description" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

if {[form is_valid category]} {
    template::form get_values category \
        keyword_id return_url heading description

    set keyword_id [classified-ads::categories::edit -keyword_id $keyword_id \
                        -heading $heading \
                        -description $description \
                       ]

    ad_returnredirect $return_url
    ad_script_abort
}

set title "Edit"
set context [classified-ads::categories::generate_trail -keyword_id $keyword_id -append_element $title]

if { [form is_request category] } {
    # Select info for this category
    classified-ads::categories::get -keyword_id $keyword_id -array category_info

    element set_properties category keyword_id -value $keyword_id
    element set_properties category return_url -value $return_url
    element set_properties category heading -value $category_info(heading)
    element set_properties category description -value $category_info(description)
}

ad_return_template
