ad_page_contract {

    Classified Ads Administration

    @author Deds Castillo (deds@infiniteinfo.com)
    @author Roberto Mello
    @creation-date 2002-10-08
    @cvs-id $Id: categories.tcl,v 1.6 2003/07/30 04:56:41 rmello Exp $

} {
    {keyword_id ""}
    {display ""}
}

set root_folder_id [classified-ads::get_root_folder_id]
set package_category_id [classified-ads::categories::get_package_keyword_id]
set package_category_p 0
set title "Categories"

if {[empty_string_p $keyword_id]} {
    set keyword_id $package_category_id
    set package_category_p 1
} elseif {[string equal [classified-ads::get_main_keyword_id] $keyword_id]} {
    ad_return_complaint 1 "<li> No access to the root id"
    ad_script_abort
} else {
    # Select info for this category
    classified-ads::categories::get -keyword_id $keyword_id -array category_info
    set title $category_info(heading)
}

db_multirow categories select_categories {}

template::util::list_of_ns_sets_to_multirow \
    -rows [classified-ads::ads::get_unassigned_ads_by_category] \
    -var_name unassigned_ads

template::util::list_of_ns_sets_to_multirow \
    -rows [classified-ads::ads::get_assigned_ads_by_category -category_id $keyword_id] \
    -var_name assigned_ads

set return_url "[ad_conn url]?[ad_conn query]"
set context [classified-ads::categories::generate_trail -keyword_id $keyword_id]

ad_return_template
