ad_page_contract {
    Display/Edit a Classified Ad

    @author Roberto Mello (rmello@fslc.usu.edu)
    @creation-date 2003-07-19
    @cvs-id $Id: ad-one.tcl,v 1.6 2003/07/25 23:53:20 rmello Exp $

} {
    {ad_id:integer}
    {revision_id ""}
    {mode "display"}
    {return_url "categories"}
}

#
# Only needed in non-admin version
#
# set user_id [ad_conn user_id]

#####
# Actions
#####

set actions [list [list "   Edit   " edit] [list "   Delete   " delete]]
set url_title "Ad $ad_id"
set context [classified-ads::ads::generate_trail -ad_id $ad_id]
set action [form get_action ad]

#
# Get information for this ad
#

classified-ads::ads::get -ad_id $ad_id -revision_id $revision_id -array adinfo

#
# If no return_url was passed, let's return to the category of this
# particular ad.
#

if { [string equal $return_url "categories"] } {
	set return_url "categories?keyword_id=$adinfo(keyword_id)"
}

#
# Now we're ready to create the form
#

ad_form -name ad -cancel_url $return_url -mode display -actions $actions -form {
	ad_id:key
	{return_url:text(hidden)	{label "return url"}
					{value $return_url} }
	{title:text(text)		{label "Title"}
					{html {size 60} {maxlength 1000}} }
	{description:text(textarea)	{label "Short Description"}
					{optional}
					{html {cols 60 rows 3 wrap soft}} } 
	{data:text(textarea)		{label "Content"} 
					{optional}
					{html {cols 60 rows 10 wrap soft}} }

} 

#
# Get extra custom widgets, if any
#

classified-ads::widgets::get_widget_params \
		-content_type "ca_ad" \
		-form_id ad \
		-keyword_id $adinfo(keyword_id)

if {[template::form is_request ad]} {
	#
	# If this is not a submission, get the values we have stored for
	# custom fields.
	#

	set form_values [classified-ads::get_attribute_values -item_id $ad_id -item_id_element ad_id]

	classified-ads::widgets::set_widget_values -form_id ad -form_values $form_values

	template::element::set_value ad title $adinfo(title)
	template::element::set_value ad description $adinfo(description)
	template::element::set_value ad data $adinfo(data)
}

ad_form -extend -name ad -edit_data {
	set ad_id [classified-ads::ads::edit \
			-item_id_element ad_id \
			-form_id ad]

	template::form get_values ad return_url

	ad_returnredirect $return_url
	ad_script_abort

} -edit_request {
	if { [string equal $action "delete"] } {
		#
		# If the delete button was pressed
		#

		set title [template::element::get_value ad title]
		set description [template::element::get_value ad description]

		#
		# Tried to use rp_internal_redirect but had problems. 
		# This is less elegant but works.
		#

		ad_returnredirect "ad-delete?[export_vars -url {ad_id title description return_url context}]"
		ad_script_abort
	}
	
} 

ad_return_template
