ad_page_contract {
    
    Create a Classified Ads Ad

    @author Deds Castillo (deds@infiniteinfo.com)
    @modified-by Roberto Mello (rmello@fslc.usu.edu)
    @creation-date 2002-10-08
    @cvs-id $Id: ad-new.tcl,v 1.7 2003/07/31 09:31:01 rmello Exp $

} {
    {keyword_id:integer,optional}
    {return_url "categories"}
}

if {![info exists keyword_id]} {
    set package_category_id [classified-ads::categories::get_package_keyword_id]
    set keyword_id $package_category_id
    set title "Place New Ad (no category)"
    
} elseif {[string equal [classified-ads::get_main_keyword_id] $keyword_id]} {
    ad_return_complaint 1 "<li> No access to the root id"
    ad_script_abort

} else {
    # Select info for this category
    
    classified-ads::categories::get -keyword_id $keyword_id -array category_info
    set category_heading $category_info(heading)
    set title "Place New $category_heading Ad"

    # If default return_url, make sure we send the user to this category

    if { [string equal $return_url "categories"] } {
        set return_url "categories?keyword_id=$keyword_id"
    }
}

ad_form -name ad -form {
	ad_id:key
	{return_url:text(hidden)	{label "return url"}
					{value $return_url} }
	{keyword_id:integer(hidden)	{label "Keyword ID"}
					{value $keyword_id} }
	{title:text(text)		{label "Title"}
					{html {size 60} {maxlength 1000}} }
	{description:text(textarea),optional	{label "Short Description"}
					{html {cols 60 rows 3 wrap soft}} } 
	{data:text(textarea),optional	{label "Content"} 
					{html {cols 60 rows 10 wrap soft}} }
} -on_request {
	# Get extra custom widgets, if any

	classified-ads::widgets::get_widget_params \
		-content_type "ca_ad" \
		-form_id ad \
		-keyword_id $keyword_id

	#
	# If this is not a submission, get the values we have stored for
	# custom fields.
	#

	set form_values [classified-ads::get_attribute_values -item_id $ad_id -item_id_element ad_id]

	classified-ads::widgets::set_widget_values -form_id ad -form_values $form_values

} -new_data {
	set ad_id [classified-ads::ads::new \
			-item_id_element ad_id \
			-form_id ad \
			-category_id $keyword_id]

	template::form get_values ad return_url

	ad_returnredirect $return_url
	ad_script_abort
}


set context [list [list "ads" "Ads"] $title]

ad_return_template
