ad_page_contract {
    
    Create a Classified Ads Ad

    @author Deds Castillo (deds@infiniteinfo.com)
    @creation-date 2002-10-08
    @cvs-id $Id: ad-edit.tcl,v 1.1 2003/07/16 04:52:32 rmello Exp $

} {
    {ad_id:notnull,integer}
    {revision_id ""}
    {return_url "ads"}
}

form create ad

element create ad ad_id \
    -label "Ad ID" \
    -datatype integer \
    -widget hidden

element create ad return_url \
    -label "Return URL" \
    -datatype text \
    -widget hidden \
    -value $return_url

element create ad title \
    -label "Title" \
    -datatype text \
    -widget text \
    -html {size 60 maxlength 1000}

element create ad description \
    -label "Description" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

element create ad data \
    -label "Content" \
    -datatype text \
    -widget textarea \
    -html {cols 60 rows 10 wrap soft} \
    -optional

classified-ads::widgets::get_widget_params -content_type "ca_ad" -form_id ad


if {[form is_valid ad]} {

    set ad_id [classified-ads::ads::edit -item_id_element ad_id -form_id ad]

    template::form get_values ad \
        return_url

    ad_returnredirect $return_url
    ad_script_abort
}

if { [form is_request ad] } {
    set form_values [classified-ads::get_attribute_values -item_id $ad_id -item_id_element ad_id]
    classified-ads::widgets::set_widget_values -form_id ad -form_values $form_values

    classified-ads::ads::get -ad_id $ad_id -revision_id $revision_id -array adinfo
    element set_properties ad ad_id -value $ad_id
    element set_properties ad title -value $adinfo(title)
    element set_properties ad description -value $adinfo(description)
    element set_properties ad data -value $adinfo(data)
}

set title "Edit"
set context [list [list "ads" "Ads"] $title]

ad_return_template
