ad_page_contract {
    
    Delete an Ad (1 of 2)

    @author Roberto Mello 
    @creation-date 2003-07-20
    @cvs-id $Id: ad-delete.tcl,v 1.3 2003/07/23 21:08:19 rmello Exp $

} {
    ad_id:integer,notnull
    title:notnull
    description:notnull
    {return_url "categories"}
    context:notnull
}

set actions [list [list "Yes, Delete this Ad" delete] [list "   Cancel   " cancel]]
set action [form get_action ad_delete]

switch $action {
	"delete" {
		if {[catch {classified-ads::ads::delete -ad_id $ad_id} errmsg]} {
    			ad_return_error "Problems deleting ad" "<li> The following error occured during deletion: $errmsg"
    			ad_script_abort
		}
		ad_returnredirect $return_url
		ad_script_abort
	}
	"cancel" {
		ad_returnredirect "ad-one?ad_id=$ad_id&return_url=[export_vars -url $return_url]"
		ad_script_abort
	}
}

ad_form -name ad_delete -export ad_id \
	-mode display \
	-actions $actions \
	-form {

	{title:text(text)		{label "Title"}
					{value $title}
					{section "Are you sure you want to delete this ad?"}}
	{description:text(textarea)	{label "Short Description"}
					{value $description}
					{html {cols 60 rows 3 wrap soft}} } 
	{context:text(hidden)		{value $context}}
	
} 
