-- Classified Ads Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-10-08
-- @cvs-id $Id: post-steps-drop.sql,v 1.1 2003/07/16 04:52:31 rmello Exp $
--

create function inline_0 ()
returns integer as'
declare
    v_package_key           apm_packages.package_key%TYPE;
    v_name                  cr_items.name%TYPE;
    v_label                 cr_folders.label%TYPE;
    v_folder_description    cr_folders.description%TYPE;
    v_folder_id             cr_folders.folder_id%TYPE;
    v_rec                   record;
begin

-- these are magic values
    v_package_key := ''classified-ads'';
    v_name := v_package_key;
    v_label := v_package_key;
    v_folder_description := v_package_key || '' Root Folder, all classified ads items go here'';

-- get the root folder id for classified ads
    select folder_id into v_folder_id
    from cr_folders f, cr_items i
    where i.name = v_name and
          f.label = v_label and
          f.description = v_folder_description;

    
-- remove association of content types from all classified ads folder
    for v_rec in
        select a2.object_id
        from acs_objects a1, acs_objects a2
        where a1.object_id = v_folder_id and
              a2.tree_sortkey between a1.tree_sortkey and tree_right(a1.tree_sortkey) and
              a2.object_type = ''content_folder''
        order by a2.tree_sortkey desc
    LOOP
        PERFORM content_folder__unregister_content_type (
            v_rec.object_id,        -- folder_id
            ''content_folder'',     -- content_type
            ''t''                   -- include_subtypes
        );

        PERFORM content_folder__unregister_content_type (
            v_rec.object_id,        -- folder_id
            ''content_revision'',   -- content_type
            ''t''                   -- include_subtypes
        );

        PERFORM content_folder__unregister_content_type (
            v_rec.object_id,    -- folder_id
            ''ca_ad'',          -- content_type
            ''t''               -- include_subtypes
        );

    end LOOP;

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0();
