-- Classified Ads Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-10-08
-- @cvs-id $Id: cr-classifieds-package-create.sql,v 1.1 2003/07/16 04:52:31 rmello Exp $
--

select define_function_args('ca__get_folder_id','package_id');

create function ca__get_folder_id (integer)
returns integer as '
declare
    p_package_id alias for $1;
    v_folder_id integer;
begin
    select folder_id into v_folder_id
    from cr_folders
    where package_id = p_package_id;
    if not found then 
        v_folder_id := 0;
    end if;

    return v_folder_id;
end;
' language 'plpgsql';


select define_function_args('ca__set_package_folder','folder_id,package_id');

create function ca__set_package_folder (integer,integer)
returns integer as '
declare
    p_folder_id                     alias for $1;
    p_package_id                    alias for $2;
begin
    update cr_folders
    set package_id = p_package_id
    where folder_id = p_folder_id;

    return p_folder_id;
end;
' language 'plpgsql';

create or replace function ca_ads__name (integer)
returns varchar as '
declare
    p_ad_id				alias for $1;
    v_title				cr_revisions.title%TYPE;

begin
    select into v_title title
    from cr_revisions
    where revision_id=p_ad_id;

    return v_title;
end;' language 'plpgsql';


