-- Classified Ads Package
--
-- @author Deds Castillo (deds@infiniteinfo.com)
-- @creation-date 2002-10-08
-- @cvs-id $Id: cr-classifieds-create.sql,v 1.1 2003/07/16 04:52:31 rmello Exp $
--

create function inline_0 ()
returns integer as'
declare
    v_package_key           apm_packages.package_key%TYPE;
    v_name                  cr_items.name%TYPE;
    v_label                 cr_folders.label%TYPE;
    v_folder_description    cr_folders.description%TYPE;
    v_heading               cr_keywords.heading%TYPE;
    v_keyword_description   cr_keywords.description%TYPE;
    v_folder_id             cr_folders.folder_id%TYPE;
begin

-- these are magic values
    v_package_key := ''classified-ads'';
    v_name := v_package_key;
    v_label := v_package_key;
    v_folder_description := v_package_key || '' Root Folder, all classified ads items go here'';
    v_heading := v_package_key || ''-main-category'';
    v_keyword_description := v_heading || '' Main Category, this is where all classified ads categories are rooted'';
    
-- create the root folder for classified ads
    v_folder_id := content_folder__new (
        v_name,                -- name
        v_label,               -- label
        v_folder_description,  -- description
        null                   -- parent_id
    );

-- create the root keyword for classified ads
-- this is used for categorization
    PERFORM content_keyword__new (
        v_heading,                -- heading
        v_keyword_description,    -- description
        null,                     -- parent_id
        null,                     -- keyword_id
        now(),                    -- creation_date
        null,                     -- creation_user
        null,                     -- creation_ip
        ''content_keyword''       -- object_type
    );

    return null;
end;' language 'plpgsql';

select inline_0();
drop function inline_0();
