ad_page_contract {
    gets the bcms page and related items
} {
	revision_id:optional,naturalnum
    {printer_friendly_p:optional 0}
}

# get the root_id that this bcds is serving
set root_id [parameter::get -parameter root_folder_id]
set root_url [ad_conn package_url]

set extra_url [ad_conn extra_url]
if [string equal $extra_url ""] {set extra_url index}

# get the item by url if now revision id is given
if ![info exists revision_id] {
    array set current_item [bcms::item::get_item_by_url -root_id $root_id -url $extra_url -revision live]
} else {
    array set current_item [bcms::revision::get_revision -revision_id $revision_id]
}

# check to see if there is a content item for this url.
# array size 1 is item is present but not live
# array size 0 there is no item in this url
if {[array size current_item] > 1} {

    # if content is a file then stream it out
    if [string equal $current_item(storage_type) "file"] {
        cr_write_content -revision_id $current_item(revision_id)
        ad_script_abort
    }

    # lets check if we need to have / on the url
    # if the item is index but the last urlv is not index or the url does not have / on the end
    # we need to redirect.
    set current_url_list [ad_conn urlv]
    set current_url [ad_conn url]
    if {![string equal [lindex  $current_url_list end] "index"] \
            && ![regexp {/$} $current_url] \
            && [string equal $current_item(name) "index"]} {
        ad_returnredirect "$current_url/"
    }

    # get the pages on the same level
    bcms::item::list_pages -parent_id $current_item(parent_id) -revision live -multirow_name pages

    # get the related images
    bcms::item::list_related_items -item_id $current_item(item_id) -revision latest -relation_tag images -multirow_name related_images

    # get the related files
    bcms::item::list_related_items -item_id $current_item(item_id) -revision latest -relation_tag files -multirow_name related_files

    if {$printer_friendly_p} {
        ad_return_template printer-friendly
    } else {

        # get the template for this item
        array set one_template [bcds::get_template -item_id $current_item(item_id)]

        # check to see if there is a template of this item if not look at the folder template
        # if not serve the default template
        if {[array size one_template] > 0} {
            ad_return_template $one_template(name)
        } else {
            # get the template for this item
            array set one_template [bcds::get_template -item_id $current_item(parent_id)]
            if {[array size one_template] > 0} {
                ad_return_template $one_template(name)
            } else {
                ad_return_template
            }
        }
    }
} else {
	ns_returnnotfound
	ad_script_abort
}


