ad_page_contract {
	add and edit a template
} {
	item_id:optional,naturalnum
	{return_url:optional ""}
}

ad_form -name onetemplate -html {enctype multipart/form-data} -form {

	item_id:key

	{name:text(text) {label "Name"}}
    {title:text(text) {label "Title"}}
    {description:text(textarea),optional {html {rows 5 cols 80}} {label "Description"}}
    {content:text(textarea),optional {html {rows 20 cols 80}} {label "Template Code"}}
    {upload_file:filename(file),optional {label "File"}}
	{return_url:text(hidden) {value $return_url}}

} -edit_request {

    array set one_item [bcms::item::get_item -item_id $item_id]
	set name $one_item(name)

	array set one_revision [bcms::item::get_item_best -item_id $item_id]
	set title $one_revision(title)
	set description $one_revision(description)
	set content $one_revision(content)

	ad_set_form_values name title description content

} -new_data {

	set creation_user_id [ad_conn user_id]
	set creation_ip [ad_conn peeraddr]

# TODO: revisit file upload function
# revise so that we can accomodate on a per instance of bcds
	db_transaction {
		set item_id [bcds::create_template -template_name $name \
						 -creation_user_id $creation_user_id -creation_ip $creation_ip]

		bcms::revision::revision_create_in_text -item_id $item_id -content_type content_revision \
			-title $title -content $content -description $description \
			-mime_type "text/html" \
			-creation_user_id $creation_user_id -creation_ip $creation_ip
	}

	set file "[acs_root_dir]/packages/bcds/www/templates/${name}.adp"
	template::util::write_file $file $content

	if ![string equal $return_url ""] {
		ad_returnredirect $return_url
	}
} -edit_data {

	array set one_revision [bcms::item::get_item_best -item_id $item_id]
	set revision_id $one_revision(revision_id)

	bcms::item::edit_item -item_id $item_id -name $name

	bcms::revision::edit_revision -revision_id $revision_id \
	-title $title -content $content -description $description 

	set file "[acs_root_dir]/packages/bcds/www/templates/${name}.adp"
	template::util::write_file $file $content

	if ![string equal $return_url ""] {
		ad_returnredirect $return_url
	}
}
