ad_library {

	Procs for openFTS search

}

namespace eval bcds::search {

    ad_proc -public datasource {
        object_id
    } {
        openfts datasource implementation
    } {
        db_1row get_datasource {
            select r.revision_id as object_id,
                r.title as title,
	            r.content as content,
	            r.mime_type as mime,
                '' as keywords,
	            i.storage_type as storage_type
	        from cr_revisions r, cr_items i
	            where revision_id = :object_id
                and i.item_id = r.item_id
        } -column_array datasource_array

        return [array get datasource_array]
    }


    ad_proc -public url {
        object_id
    } {
        openfts url implementation
    } {

        # TODO: we need to rethink about this outside on generic terms
        # currently we hard code the root_url and getting the package id

        set root_url "/site/"
        set root_id [parameter::get_from_package_key -package_key bcds -parameter root_folder_id]

        db_1row get_url {
            select content_item__get_path(r.item_id, :root_id) as page_url
                from cr_revisions r
            where r.revision_id = :object_id
        }

        return "$root_url$page_url"

    }

# end of bcds::search
}
