ad_library {

	Procs for content_template, and some helper procs

}

namespace eval bcds {

	ad_proc -public create_template {
		{-template_name:required}
        {-parent_id}
		{-creation_user_id ""}
		{-creation_ip ""}
	} {
		This proc creates a template and returns the item_id of the new template
	} {
        if ![info exists parent_id] {
            set parent_id [get_bcds_root_folder]
        }
		set item_id [db_exec_plsql create_template "SQL"]
		return $item_id
	}

	ad_proc -public delete_template {
		{-template_id:required}
	} {
		Delete a template
	} {
		return [db_exec_plsql delete_template "SQL"]
	}

	# for possible contribution 
	ad_proc -public get_cr_template_root {} {
		gets the folder_id of the template root of cr
	} {
		set template_root [db_exec_plsql get_template_root "SQL"]
	}

	ad_proc -public get_bcds_root_folder {} {
		gets the root folder of bcds
	} {
		set package_id [ad_conn package_id]

		if [db_0or1row get_bcds_folder "SQL"] {
			return $folder_id
		} else {
			return 0
		}
	}
	
	ad_proc -public apply_template {
		{-item_id:required}
		{-template_id:required}
		{-context}
	} {
		applies a template to a content item with the context given or the current
		context of BCDS
	} {

		if ![info exists context] {
			set context [parameter::get -parameter context]
		}

		db_exec_plsql apply_template "SQL"

	}

    ad_proc -public unregister_template {
        {-item_id:required}
        {-template_id ""}
        {-context ""}
    } {
        unregister a template for a item_id
    } {
        db_exec_plsql unregister_template "SQL"
    }

	ad_proc -public get_template {
		{-item_id:required}
		{-context}
	} {
		gets the template of the content item on the context specified
	} {
		if ![info exists context] {
			set context [parameter::get -parameter context]
		}
		if {[db_0or1row get_template "SQL" -column_array one_template]} {
            return [array get one_template]
        } else {
            return {}
        }

	}


####################### depracated procs below...............  maybe i can get something from the old junk ##################

	ad_proc -public get_template_name {
		{-item_id:required}
		{-context}
	} {
		gets the template of the content item on the context specified

        @depracated use get_template
	} {
		if ![info exists context] {
			set context [parameter::get -parameter context]
		}
		return [db_string get_template_name "SQL" -default ""]

	}

	ad_proc -public get_content_item_id {
		{-url:required}
		{-root_id}
		{-resolve_index:boolean true}
	} {
		gets a content items based from the url and the starting root_id.
		returns the item_id of 

        @depracated use bcms::item::get_item_by_url
	} {
		if ![info exists root_id] {
			if [string equal $url ""] {
				set url "index"
			}
			set root_id [parameter::get -parameter root_folder_id]
		}
		return [db_exec_plsql get_item_id "SQL"]

	}

	ad_proc -public template_option_list {} {
		returns a list normally used for ad_form option list.  The format is
		template title, template_id

        @depracated make use of bcms::item::list_items directly
	} {
		set bcms_list_items [bcms::item::list_items -parent_id [bcds::get_bcds_root_folder] -return_list]

		# construct the option list
		set option_list [list]
		foreach one_item $bcms_list_items {
			if ![string equal [lindex $one_item [expr [lsearch $one_item content_type] + 1]] "content_folder"] {
				lappend option_list [list [lindex $one_item [expr [lsearch $one_item name] + 1]] \
										 [lindex $one_item [expr [lsearch $one_item item_id] + 1]]]
			}
		}
		return $option_list
		
	}


# end of bcds namespace
}

