# Repeat a template chunk for each item in a list
# similar to the stock "list" tag.  But this one adds
# support for list of lists.  Similar to how multiple
# tag works
# ex.  <bcds_list name="mylist" list_type="listoflists">
#          @mylist_1row.firstname@ @mylist_1row.lastname
#      </bcds_list>

# for possible contribution

template_tag bcds_list { chunk params } {

  # the list tag accepts a value so that it may be used without a data
  # source in the tcl script

  set value [ns_set iget $params value]

  # If the value exists, use it and create a fake name for it

  if { ![template::util::is_nil value] } {

    set name [ns_set iget $params name]
    if { [empty_string_p $name] } {
      set name "__ats_list_value"
    }

    template::adp_append_code "\nset $name \[eval list $value\]\n"
    template::adp_append_code "\nset $name:rowcount \[llength \$$name\]\n"

  } else {

    # Expect a data source from the tcl script
    set name [template::get_attribute list $params name]
    template::adp_append_code "\nset {$name:rowcount} \[llength \${$name}\]\n"
  }

  set list_type [template::get_attribute bcds_list $params list_type list]
  
  template::adp_append_code "

  for { set __ats_i 0 } { \$__ats_i < \${$name:rowcount} } { incr __ats_i } {"

  if [string equal $list_type "listoflists"] {
	  template::adp_append_code "
    array set ${name}_1row \[lindex \${$name} \$__ats_i\]"
  } else {
	  template::adp_append_code "
    set $name:item \[lindex \${$name} \$__ats_i\]"
  }

  template::adp_append_code "
    set $name:rownum \[expr \$__ats_i + 1\]
  "
  template::adp_compile_chunk $chunk

  template::adp_append_code "}"
}  
