/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JabberConnection
extends Thread
implements TagListener {
    String server;
    int port;
    UI p;
    Pinger pinger;
    Socket s;
    BufferedReader in;
    DataOutputStream os;
    OutputStreamWriter osw;
    BufferedWriter bw;
    XMLTagParser xmltp = null;
    boolean newA = false;
    String email = "user@server.type";
    int state = 0;
    final int INITSTATE = 0;
    final int SASL = 1;
    final int NOTSASL = 2;
    final int QUERIEDAUTH = 3;
    final int SENTLOGINDATA = 4;
    final int LOGGEDIN = 5;
    final int NEWA = 10;
    String streamid = "";
    String username = "";
    String password = "";
    boolean usePlainPasswd = false;
    boolean useSSL = false;
    String resource = "handheld";
    Vector iql = new Vector();

    public void setNew(boolean bl) {
        this.newA = bl;
    }

    JabberConnection(UI uI) {
        this.p = uI;
        this.password = uI.getPassword();
        this.username = uI.getUsername();
        this.useSSL = uI.getUseSSL();
        this.usePlainPasswd = uI.getUsePlainPasswd();
    }

    public void connectionEstablished() {
    }

    public void connectionDisconnected() {
    }

    public void messageRecieved() {
    }

    public void sendMessage(Message message) {
    }

    public void sendIQ(IQMessage iQMessage) {
    }

    public void iqRecieved() {
    }

    public void connect() {
        this.p.setInfo("Starting.");
        try {
            this.state = 0;
            this.s = new Socket(this.server, this.port);
            this.in = new BufferedReader(new InputStreamReader(this.s.getInputStream(), "UTF8"));
            this.os = new DataOutputStream(this.s.getOutputStream());
            this.osw = new OutputStreamWriter((OutputStream)this.os, "UTF8");
            this.bw = new BufferedWriter(this.osw);
            if (this.pinger != null) {
                this.pinger.stop();
                this.pinger.jc = this;
                this.pinger.start();
            } else {
                this.pinger = new Pinger(this);
                this.pinger.start();
            }
            this.p.setInfo("connected, starting.");
            if (this.xmltp == null) {
                this.xmltp = new XMLTagParser();
                this.xmltp.attach(this);
            }
            this.startStream();
        }
        catch (Exception exception) {
            this.p.setInfo("" + exception);
            exception.printStackTrace();
        }
    }

    public void disconnect() {
        this.p.setInfo("Shutting down connection.");
    }

    public void run() {
        try {
            this.connect();
            while (true) {
                char c = (char)this.in.read();
                this.xmltp.addChar(c);
            }
        }
        catch (Exception exception) {
            this.disconnect();
            return;
        }
    }

    public void rawSend(String string) {
        try {
            this.bw.write(string + "\n");
            this.bw.flush();
            System.out.println("****** OUT:" + string);
        }
        catch (Exception exception) {
            this.p.print("" + exception);
        }
    }

    public void startStream() {
        try {
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
            this.rawSend(string);
            string = "<stream:stream to=\"" + this.server + "\" xmlns=\"jabber:client\" xmlns:stream=\"http://etherx.jabber.org/streams\">";
            this.rawSend(string);
        }
        catch (Exception exception) {
            this.p.setInfo("" + exception);
        }
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void tagStop(Element element) {
        System.out.println("Jabber parser:Tag end recieved:" + element.name);
        switch (this.state) {
            case 3: {
                this.p.print("*** Reply recieved:" + element.name);
                if (!element.name.equals("iq")) break;
                this.parseAuthRequestReply(element);
                break;
            }
            case 4: {
                if (!element.name.equals("iq")) break;
                if (element.isEmpty()) {
                    this.p.print("Positive authentification.");
                    this.p.displayMain();
                    this.requestRoster();
                    this.state = 5;
                    this.sendPresence();
                    this.loadPrivateParameters();
                    break;
                }
                this.p.print("Negative authentification.");
                break;
            }
            case 5: {
                this.handle(element);
                break;
            }
            case 10: {
                this.handle(element);
            }
        }
    }

    public void tagStart(Element element) {
        switch (this.state) {
            case 0: {
                if (element.name.equals("?xml")) {
                    this.xmltp = new XMLTagParser();
                    this.xmltp.attach(this);
                }
                if (!element.name.equals("stream:stream")) break;
                this.p.print("Stream tag detected.");
                this.p.print("Checking if server supports SASL");
                if (element.attributes.contains("xmlns:sasl")) {
                    this.p.print("Server supports SASL");
                    this.state = 1;
                } else {
                    this.p.print("Server doesn't support SASL");
                    this.state = 2;
                }
                this.p.print("Extracting stream id.");
                this.streamid = (String)element.attributes.get("id");
                this.tagStart(element);
                this.xmltp = new XMLTagParser();
                this.xmltp.attach(this);
                break;
            }
            case 1: {
                if (!element.name.equals("sasl:mechanisms")) break;
                this.p.print("SASL mechanisms arrived.");
                break;
            }
            case 2: {
                this.p.print("*** Querying auth");
                if (this.newA) {
                    this.state = 10;
                    this.p.setInfo("Querying new account.");
                    this.queryRegistration();
                    break;
                }
                this.state = 3;
                this.queryAuth();
                break;
            }
            case 3: {
                this.p.print("*** Reply recieved:" + element.name);
                if (!element.name.equals("iq")) break;
                this.parseAuthRequestReply(element);
            }
        }
    }

    public void sendPresence(String string) {
        String string2 = "<presence to=\"" + string + "\"/>";
        this.rawSend(string2);
    }

    public void loginWithPlainPassword() {
        String string = "<iq id=\"" + this.streamid + "\" type=\"set\"><query xmlns=\"jabber:iq:auth\">";
        string = string + "<username>" + this.username + "</username>";
        string = string + "<resource>" + this.resource + "</resource>";
        string = string + "<password>" + this.password + "</password>";
        string = string + "</query></iq>\n";
        this.rawSend(string);
    }

    public void loginWithDigestPassword() {
        MessageDigest messageDigest = null;
        String string = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.update((this.streamid + this.password).getBytes());
        byte[] byArray = messageDigest.digest();
        int n = byArray.length;
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            byte by;
            int n3;
            if ((string3 = Integer.toHexString(n3 = (by = byArray[n2++]) & 0xFF)).length() == 1) {
                string3 = "0" + string3;
            }
            string2 = string2 + string3;
        }
        String string4 = "<iq id=\"" + this.streamid + "\" type=\"set\"><query xmlns=\"jabber:iq:auth\">";
        string4 = string4 + "<username>" + this.username + "</username>";
        string4 = string4 + "<resource>" + this.resource + "</resource>";
        string4 = string4 + "<digest>" + string2 + "</digest>";
        string4 = string4 + "</query></iq>\n";
        this.rawSend(string4);
    }

    public void parseAuthRequestReply(Element element) {
        this.p.print("Parsing Auth Request Reply");
        if (((String)element.attributes.get("type")).equals("result")) {
            Element element2;
            Element element3 = element.getElement("query");
            if (element3 != null && (element2 = element3.getElement("password")) != null) {
                this.p.print("using plain password for simplicitys sake.");
                this.state = 4;
                this.p.setInfo("Sending login data.");
                if (this.usePlainPasswd) {
                    this.loginWithPlainPassword();
                } else {
                    this.loginWithDigestPassword();
                }
            }
        } else if (((String)element.attributes.get("type")).equals("error")) {
            this.p.print("ERROR During auth: " + element.toString());
            Element element4 = element.getElement("error");
            if (element4 != null) {
                this.p.setInfo(element4.getText());
            }
        }
    }

    public void queryAuth() {
        String string = "<iq id=\"" + this.streamid + "\" type=\"get\"><query xmlns=\"jabber:iq:auth\">";
        string = string + "<username>" + this.username + "</username></query></iq>\n";
        this.p.setInfo("Querying auth.");
        this.rawSend(string);
    }

    public void sendGroupChat(String string, String string2) {
        String string3 = "";
        string3 = string3 + "<message type=\"groupchat\" to=\"" + string + "\"><body>" + string2 + "</body></message>";
        this.rawSend(string3);
    }

    public void sendPrivateChat(String string, String string2, String string3) {
        String string4 = "";
        string4 = string4 + "<message type=\"chat\" to=\"" + string + "\"><thread>" + string3 + "</thread><body>" + string2 + "</body></message>";
        this.rawSend(string4);
    }

    public void sendPrivateMessage(String string, String string2, String string3, String string4) {
        String string5 = "";
        string5 = string5 + "<message type=\"normal\" to=\"" + string + "\"><thread>" + string4 + "</thread><subject>" + string2 + "</subject><body>" + string3 + "</body></message>";
        this.rawSend(string5);
    }

    public void sendChat(String string, String string2) {
    }

    public String exN(String string) {
        int n = string.indexOf("/");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String exCN(String string) {
        int n = string.indexOf("/");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void handle(Element element) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        System.out.print("hhh" + element.toString());
        if (element.name.equals("message")) {
            block42: {
                object4 = element.getAttr("type");
                if (object4 == null) {
                    object4 = "";
                }
                if (((String)object4).equals("groupchat")) {
                    this.p.print("##### gc mess recieved.");
                    try {
                        object3 = this.exCN(element.getAttr("from"));
                        object2 = element.getElement("body");
                        if (object2 != null) {
                            if (!((Element)object2).getText().equals("")) {
                                this.p.print("##### handing message to groupchat");
                                this.p.getGroupChat((String)object3).processIncoming(this.exN(element.getAttr("from")), ((Element)object2).getText());
                            }
                            break block42;
                        }
                        this.p.print("#### message is empty");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (((String)object4).equals("chat")) {
                    this.p.print("##### private chat mess recieved.");
                    try {
                        object3 = this.exCN(element.getAttr("from"));
                        object2 = element.getElement("thread");
                        object = element.getElement("body");
                        if (object != null) {
                            if (!((Element)object).getText().equals("")) {
                                this.p.print("##### handing message to groupchat");
                                string = "";
                                if (object2 != null) {
                                    string = ((Element)object2).getText();
                                }
                                this.p.getPrivateChat(element.getAttr("from"), true, string).processIncoming(this.exN(element.getAttr("from")), ((Element)object).getText());
                            }
                            break block42;
                        }
                        this.p.print("#### message is empty");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (((String)object4).equals("normal") | ((String)object4).equals("")) {
                    this.p.print("##### private mess recieved.");
                    try {
                        object3 = this.exCN(element.getAttr("from"));
                        object2 = element.getElement("body");
                        if (object2 != null) {
                            if (!((Element)object2).getText().equals("")) {
                                this.p.print("##### displaying mesasage");
                                object = new Message();
                                ((Message)object).from = element.getAttr("from");
                                ((Message)object).body = object2;
                                ((Message)object).subject = element.getElement("subject");
                                this.p.displayMessage((Message)object);
                            }
                            break block42;
                        }
                        this.p.print("#### message is empty");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (((String)object4).equals("headline")) {
                    object3 = new Message();
                    ((Message)object3).x = element.getElement("x");
                    ((Message)object3).body = element.getElement("body");
                    ((Message)object3).subject = element.getElement("subject");
                    ((Message)object3).from = element.getAttr("from");
                    this.p.displayHeadline((Message)object3);
                }
            }
            this.handleIQ(element);
        }
        if (element.name.equals("iq")) {
            object4 = element.getAttr("id");
            object3 = element.getAttr("type");
            object2 = element.getAttr("from");
            if (((String)object3).equals("get") && element.getElement("query") != null && ((String)(object = element.getElement("query").getAttr("xmlns"))).equals("jabber:iq:version")) {
                string = "<iq";
                if (object4 != null) {
                    string = string + " id='" + (String)object4 + "'";
                }
                string = string + " to='" + (String)object2 + "' type='result'><query xmlns='jabber:iq:version'>";
                string = string + "<name>GreenThumb -  uls@jabber.org, et al.</name>";
                string = string + "<version>1.0</version>";
                string = string + "<os>java 1.1</os></query></iq>";
                this.rawSend(string);
            }
            if (((String)object3).equals("result")) {
                if (element.getElement("query") != null) {
                    if (element.getAttr("id").equals("LOAD")) {
                        this.parsePrivateParameters(element);
                    }
                    if (element.getAttr("id").equals("registration")) {
                        this.register();
                    }
                    if (((String)(object = element.getElement("query").getAttr("xmlns"))).equals("jabber:iq:roster")) {
                        this.parseRoster(element.getElement("query"));
                        string = "<presence from=\"" + element.getAttr("from") + "\" to=\"" + "to" + "\" type=\"subscribe\" >";
                    }
                } else if (element.getAttr("id").equals("reg2")) {
                    this.p.setInfo("Registration successfull.");
                    this.newA = false;
                    this.p.disableNewAccount();
                    this.p.connectPressed();
                }
            }
            if (((String)element.attributes.get("type")).equals("error")) {
                this.p.print("ERROR During auth: " + element.toString());
                object = element.getElement("error");
                if (object != null) {
                    this.p.setInfo(((Element)object).getText());
                }
            }
            this.handleIQ(element);
        }
        if (element.name.equals("presence")) {
            object4 = element.getElement("show");
            if (object4 == null) {
                object3 = this.p.getContact(element.getAttr("from"));
                object2 = element.getAttr("type");
                if (object2 != null) {
                    if (((String)object2).equals("unavailable")) {
                        if (this.p.getChannelFor(element.getAttr("from")) != null) {
                            this.p.getChannelFor(element.getAttr("from")).displayStatus((Contact)object3);
                        }
                        this.p.removeContact((Contact)object3);
                    }
                    if (((String)object2).equals("subscribe")) {
                        this.p.displaySubReq(element);
                    }
                }
                ((Contact)object3).show = "online";
            } else {
                object3 = this.p.getContact(element.getAttr("from"));
                ((Contact)object3).show = ((Element)object4).getText();
                if (this.p.getChannelFor(element.getAttr("from")) != null) {
                    this.p.getChannelFor(element.getAttr("from")).displayStatus((Contact)object3);
                }
            }
            this.p.getRoster().rebuildRoster();
        }
    }

    public void sendPresence() {
        String string = "";
        string = string + "<presence></presence>";
        this.rawSend(string);
    }

    public void requestRoster() {
        String string = "";
        string = "<iq id='roster' type='get'><query xmlns='jabber:iq:roster'/></iq>";
        this.rawSend(string);
    }

    public void sendPresence(String string, String string2, String string3) {
        String string4 = "";
        string4 = string4 + "<presence to=\"" + string + "\"><status>" + string2 + "</status><show>" + string3 + "</show></presence>";
        if (string.equals("")) {
            string4 = "<presence><status>" + string2 + "</status><show>" + string3 + "</show></presence>";
        }
        this.rawSend(string4);
    }

    public void handleIQ(Element element) {
        System.out.println("Checking iq.");
        int n = 0;
        while (n < this.iql.size()) {
            IQListener iQListener = (IQListener)this.iql.elementAt(n);
            iQListener.handle(element);
            ++n;
        }
    }

    public void addIQL(IQListener iQListener) {
        if (!this.iql.contains(iQListener)) {
            this.iql.addElement(iQListener);
        }
    }

    public void removeIQL(IQListener iQListener) {
        this.iql.removeElement(iQListener);
    }

    public void parseRoster(Element element) {
        int n = 0;
        while (n < element.elements.size()) {
            Element element2 = (Element)element.elements.elementAt(n);
            String string = element2.getAttr("jid");
            String string2 = element2.getAttr("name");
            String string3 = element2.getAttr("subscription");
            Contact contact = new Contact(string, this.p);
            contact.jid = string;
            contact.name = string2;
            contact.subscription = string3;
            int n2 = 0;
            while (n2 < element2.elements.size()) {
                Element element3 = (Element)element2.elements.elementAt(n2);
                contact.cgs.addElement(element3.getText());
                ++n2;
            }
            this.p.getContacts().addElement(contact);
            ++n;
        }
        this.p.getRoster().rebuildRoster();
    }

    public void acceptS(String string) {
        String string2 = "<presence to='" + string + "' type='subscribed'/>";
        this.rawSend(string2);
    }

    public void savePrivateParameters() {
        String string = "<iq type='set' id='SAVE'><query xmlns='jabber:iq:private'>";
        string = string + "<greenthumb xmlns='greenthumb'><n1>" + this.p.getNick1() + "</n1>";
        string = string + "<n2>" + this.p.getNick2() + "</n2><n3>" + this.p.getNick3() + "</n3>";
        string = string + "<r1>" + this.p.getRoom1() + "</r1><r2>" + this.p.getRoom2() + "</r2><r3>" + this.p.getRoom3() + "</r3>";
        string = string + "<layout>" + this.p.getLayoutStyle() + "</layout>";
        string = string + "</greenthumb>";
        string = string + "</query></iq>";
        this.rawSend(string);
    }

    public void loadPrivateParameters() {
        String string = "<iq type='get' id='LOAD'><query xmlns='jabber:iq:private'><greenthumb xmlns='greenthumb'/></query></iq>";
        this.rawSend(string);
    }

    public void parsePrivateParameters(Element element) {
        try {
            Element element2 = element.getElement("query");
            Element element3 = element2.getElement("greenthumb");
            Element element4 = element3.getElement("n1");
            Element element5 = element3.getElement("n2");
            Element element6 = element3.getElement("n3");
            Element element7 = element3.getElement("r1");
            Element element8 = element3.getElement("r2");
            Element element9 = element3.getElement("r3");
            Element element10 = element3.getElement("layout");
            this.p.setNick1(element4.getText());
            this.p.setNick2(element5.getText());
            this.p.setNick3(element6.getText());
            this.p.setRoom1(element7.getText());
            this.p.setRoom2(element8.getText());
            this.p.setRoom3(element9.getText());
            try {
                Integer n = new Integer(element10.getText());
                this.p.setLayoutStyle(n);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSubscriptionRequest(String string, String string2, String string3, String string4) {
        String string5 = "<iq type='set'>";
        string5 = string5 + "<query xmlns='jabber:iq:roster'>";
        string5 = string5 + "<item jid='" + string + "' subscription='to' name='" + string2 + "'><group>" + string3 + "</group>";
        string5 = string5 + "</item></query></iq>";
        this.rawSend(string5);
    }

    public void register() {
        String string = "<iq type='set' to='" + this.server + "' id='reg2'>";
        string = string + "<query xmlns='jabber:iq:register'><email>" + this.email + "</email>";
        string = string + "<password>" + this.password + "</password>";
        string = string + "<username>" + this.username + "</username>";
        string = string + "</query></iq>";
        this.p.setInfo("Transmitting account information.");
        this.rawSend(string);
    }

    public void queryRegistration() {
        String string = "<iq type=\"get\" to=\"" + this.server + "\" id=\"registration\">";
        string = string + "<query xmlns=\"jabber:iq:register\"></query></iq>";
        this.p.setInfo("Querying reg. info.");
        this.rawSend(string);
    }
}

