/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

class GroupchatPanel
extends Panel
implements KeyListener,
IQListener,
QuickChoosable {
    public String type = "groupchat";
    public String thread = "";
    public Vector contacts = new Vector();
    public TextArea incoming;
    public TextField outgoing;
    Button b;
    Panel main = new Panel();
    int layout = 0;
    E4 p;
    String name = "";

    public GroupchatPanel(E4 e4, String string) {
        Panel panel;
        this.layout = e4.layout;
        this.p = e4;
        this.name = string;
        this.incoming = new TextArea(string, 30, 30, 1);
        this.outgoing = new TextField(30);
        this.incoming.setBackground(new Color(250, 255, 255));
        this.outgoing.addKeyListener(this);
        this.outgoing.setColumns(10);
        this.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3));
        Button button = new Button("/list");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatPanel.this.outgoing.setText("/list");
                GroupchatPanel.this.processOutgoing("/list");
                GroupchatPanel.this.outgoing.setText("");
            }
        });
        Button button2 = new Button("/msg ");
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatPanel.this.outgoing.setText("/msg nick text");
            }
        });
        Button button3 = new Button("/quit");
        button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupchatPanel.this.outgoing.setText("/quit");
            }
        });
        panel2.add(button);
        panel2.add(button2);
        panel2.add(button3);
        if (this.layout == 0) {
            panel = new Panel();
            panel.setLayout(new GridLayout(2, 1));
            panel.add(panel2);
            panel.add(this.outgoing);
            this.add((Component)panel, "North");
            this.add((Component)this.incoming, "Center");
        }
        if (this.layout == 1) {
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)panel2, "North");
            panel.add((Component)this.incoming, "Center");
            panel.add((Component)this.outgoing, "South");
            this.add((Component)panel, "Center");
        }
        e4.addQuickChooser(this, string.substring(0, string.indexOf("@")));
        this.incoming.setEditable(false);
        this.print("\nType /help to get helped.");
        this.invalidate();
        this.validate();
        try {
            this.incoming.setCaretPosition(this.incoming.getText().length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processOutgoing("GreenThumb user enters this chat room.");
    }

    public void processOutgoing(String string) {
        Object object;
        int n;
        if (string.startsWith("/nick") && (n = string.indexOf(" ")) != -1) {
            String string2 = string.substring(n + 1);
            this.p.jabcon.sendPresence(this.name + "/" + string2);
            string = "";
        }
        if (string.equals("/quit")) {
            string = "";
        }
        if (string.equals("/list")) {
            this.print("******");
            String string3 = "";
            this.print(this.contacts.size() + " members in channel.");
            int n2 = 0;
            while (n2 < this.contacts.size()) {
                object = (Contact)this.contacts.elementAt(n2);
                string3 = string3 + " " + this.p.jabcon.exN(((Contact)object).jid) + " is " + ((Contact)object).show;
                string3 = n2 == this.contacts.size() - 1 ? string3 + "." : string3 + ",";
                ++n2;
            }
            this.print(string3);
            this.print("* PARTICIPIANTS *");
            string = "";
        }
        if (string.equals("/help")) {
            this.displayHelp();
            string = "";
        }
        if (string.startsWith("/msg ")) {
            String string4 = string.substring(5);
            int n3 = string4.indexOf(" ");
            if (n3 != -1) {
                object = string4.substring(0, n3);
                String string5 = string4.substring(n3);
                this.p.jabcon.sendPrivateChat(this.name + "/" + (String)object, string5, "INITFROM" + this.name);
            }
            string = "";
        }
        String string6 = this.replaceSubString(string, "&", "&amp;");
        string6 = this.replaceSubString(string6, "'", "&apos;");
        string6 = this.replaceSubString(string6, "\"", "&quot;");
        string6 = this.replaceSubString(string6, "<", "&lt;");
        string = string6 = this.replaceSubString(string6, ">", "&gt;");
        if (!string.equals("")) {
            string = UnicodeFormatter.stringToHex(string);
            if (this.type.equals("groupchat")) {
                this.p.jabcon.sendGroupChat(this.name, string);
            }
            if (this.type.equals("chat")) {
                this.p.jabcon.sendPrivateChat(this.name, string, this.thread);
                this.processIncoming(this.p.nick1, string);
            }
        }
    }

    public void displayHelp() {
        String string = "";
        string = string + "1) /help displays this\n";
        string = string + "2) /list displays all members in this channel\n";
        this.print(string);
    }

    public void processIncoming(String string, String string2) {
        String string3 = this.replaceSubString(string2, "&amp;", "&");
        string3 = this.replaceSubString(string3, "&apos;", "'");
        string3 = this.replaceSubString(string3, "&quot;", "\"");
        string3 = this.replaceSubString(string3, "&lt;", "<");
        string2 = string3 = this.replaceSubString(string3, "&gt;", ">");
        if (string2.startsWith("/me ")) {
            string2 = this.type.equals("chat") ? "* " + string + " " + string2.substring(4) : "* " + this.p.jabcon.exN(string) + " " + string2.substring(4);
            this.print(string2);
        } else {
            this.print(string, string2);
        }
    }

    public void print(String string, String string2) {
        if (!this.p.isCenterPanel(this)) {
            this.p.hilite(this);
        }
        if (this.layout == 0) {
            this.incoming.insertText("[" + string + "] " + string2 + "\n\n", 0);
            try {
                this.incoming.setCaretPosition(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.layout == 1) {
            this.incoming.insertText("[" + string + "] " + string2 + "\n\n", this.incoming.getText().length());
            try {
                this.incoming.setCaretPosition(this.incoming.getText().length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void print(String string) {
        if (!this.p.isCenterPanel(this)) {
            this.p.hilite(this);
        }
        if (this.layout == 0) {
            this.incoming.insertText(string + "\n\n", 0);
            try {
                this.incoming.setCaretPosition(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.layout == 1) {
            this.incoming.insertText(string + "\n\n", this.incoming.getText().length());
            try {
                this.incoming.setCaretPosition(this.incoming.getText().length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 10: {
                String string = this.outgoing.getText();
                this.processOutgoing(string);
                this.outgoing.setText(" ");
                this.outgoing.setText("");
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void joinRoom() {
        String string = "";
        string = string + "<iq get='get' to='" + this.name + " id=\"JOINROOM\"'><enter xmlns='jabber:iq:conference'/></iq>";
        this.p.jabcon.rawSend(string);
        this.p.jabcon.addIQL(this);
    }

    public void handle(Element element) {
        if (!element.getAttr("type").equals("result") || !element.getAttr("from").equals(this.name) || element.getAttr("id").equals("JOINROOM")) {
            // empty if block
        }
    }

    public void selected() {
        if (this.type.equals("groupchat")) {
            this.p.displayGroupChat(this.name);
        } else {
            this.p.displayPrivateChat(this.name);
        }
    }

    public void displayStatus(Contact contact) {
        this.print("*** " + this.p.jabcon.exN(contact.jid) + " is " + contact.show);
    }

    public String replaceSubString(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + string2.length());
        return this.replaceSubString(string4 + string3 + string5, string2, string3);
    }
}

